LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
PACKAGE p_addr_convert IS
  FUNCTION convert_addr(a0, a1 : std_logic) return integer;

  FUNCTION convert_addr(a0, a1, a2 : std_logic) return integer;

  FUNCTION convert_addr(a0, a1, a2, a3 : std_logic) return integer;

END p_addr_convert;

PACKAGE BODY p_addr_convert IS
  FUNCTION convert_addr(a0, a1 : std_logic) RETURN INTEGER IS
    VARIABLE result : INTEGER := 0;
  BEGIN
    IF (a0 = '1') THEN
      result := result + 1;
    END IF;

    IF (a1 = '1') THEN 
      result := result + 2; 
    END IF;
        
    RETURN result;    
  END convert_addr;    

  FUNCTION convert_addr(a0, a1, a2 : std_logic) RETURN INTEGER IS        
    VARIABLE result : INTEGER := 0;    
  BEGIN        
                        
    result := convert_addr(a0, a1);

    IF (a2 = '1') THEN 
      result := result + 4; 
    END IF;        
    RETURN result;    
  END convert_addr;    

  FUNCTION convert_addr(a0, a1, a2, a3 : std_logic) RETURN INTEGER IS        
    VARIABLE result : INTEGER := 0;    
  BEGIN        
                        
    result := convert_addr(a0, a1, a2);

    IF (a3 = '1') THEN 
      result := result + 8; 
    END IF;        
    RETURN result;    
  END convert_addr; 

END p_addr_convert;



LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
USE WORK.p_addr_convert.ALL;
ENTITY test IS
  PORT(i0, i1, i2, i3 : in std_logic); 
END test; 

ARCHITECTURE test1 OF test IS    
  SIGNAL int1, int2, int3 : INTEGER; 
BEGIN    
  -- uses first function    
  int1 <= convert_addr(i0, i1);
    
  -- uses second function    
  int2 <= convert_addr(i0, i1, i2);
    
  -- uses third function    
  int3 <= convert_addr(i0, i1, i2, i3); 
END test1;

